package easik.sketch;

import org.jgrapht.DirectedGraph;
import org.jgrapht.graph.ListenableDirectedGraph;


/**
 * A directed graph which is also org.jgrapht.ListenableGraph.
 * 
 * @author Kevin Green 2006
 * @since 2006-08-15 Kevin Green
 * @version 2006-08-23 Kevin Green
 * 
 * @param <V> Vector
 * @param <E> Edge
 */
public class ListenableDirectedMultigraph<V, E> extends ListenableDirectedGraph
{
   /**
    * Creates a new listenable directed graph.
    *
    * @param edgeClass class on which to base factory for edges
    */
   public ListenableDirectedMultigraph(Class<? extends E> edgeClass)
   {
	   this(new DefaultDirectedMultigraph<V, E>(edgeClass));
   }
   
   /**
    * Creates a new listenable directed graph.
    *
    * @param base the backing graph.
    */
   public ListenableDirectedMultigraph(DirectedGraph<V, E> base)
   {
       super(base);
   }
}